using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class SETTINGSDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public SETTINGSDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, SETTINGS objSave)
        {
            Int32? objReturn = objSave.CRS_SETTINGS_ID;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_SETTINGS_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.COMMENTS, DateTime.Now, objSave.CREATEDBY, ref objReturn, objSave.DESCRIPTION, objSave.NAME, objSave.STD_REGISTRY_ID, DateTime.Now, objSave.UPDATEDBY, objSave.VALUE);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 CRS_SETTINGS_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_SETTINGS_delete(CURRENT_USER, CURRENT_REGISTRY_ID, CRS_SETTINGS_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public SETTINGS GetItemByRegistryName(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string NAME)
        {
            SETTINGS objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_SETTINGS_getitemByRegistryName(CURRENT_USER, CURRENT_REGISTRY_ID, NAME).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<SETTINGS> GetItems()
        {
            List<SETTINGS> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                    objReturn = dbContext.usp_SETTINGS_getitems().ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;
        }

        public SETTINGS GetItemHomePage()
        {
            SETTINGS objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                    objReturn = dbContext.usp_SETTINGS_getitemHomePage().FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;
        }

        public bool SaveAll(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, AppSettings appSettings)
        {
            bool objReturn = true;

            if (appSettings != null)
            {
                foreach (PropertyInfo pi in appSettings.GetType().GetProperties())
                {
                    SETTINGS objSave = GetItemByRegistryName(CURRENT_USER, CURRENT_REGISTRY_ID, pi.Name);
                    if (objSave == null)
                    {
                        objSave = new SETTINGS();
                        objSave.CREATED = DateTime.Now;
                        objSave.CREATEDBY = CURRENT_USER;
                    }

                    objSave.UPDATED = DateTime.Now;
                    objSave.UPDATEDBY = CURRENT_USER;
                    objSave.STD_REGISTRY_ID = CURRENT_REGISTRY_ID;
                    objSave.NAME = pi.Name;
                    object obj = pi.GetValue(appSettings);
                    if (obj != null)
                        objSave.VALUE = obj.ToString();

                    objSave.CRS_SETTINGS_ID = Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
                    if (objSave.CRS_SETTINGS_ID <= 0) objReturn = false;
                }
            }

            return objReturn;
        }

        #endregion
    }
}
